# Testing & Troubleshooting

## Pre-Launch Checklist

- [ ] Greeting sounds natural
- [ ] Happy path: caller books successfully
- [ ] FAQ: agent answers from knowledge base
- [ ] "Don't know" scenario handled gracefully
- [ ] Transfer request works
- [ ] Frustrated caller: agent de-escalates
- [ ] Off-topic: agent redirects
- [ ] Tool failure: agent handles gracefully
- [ ] Tested with real phone (not just web call)
- [ ] Transfer number verified and staffed
- [ ] Voicemail message configured
- [ ] Business name pronounced correctly
- [ ] Business hours logic works
- [ ] CRM/SMS integrations tested end-to-end

## Testing Methods

1. **Web Test Call** — Click "Test Agent" in dashboard. Fastest iteration.
2. **Phone Test** — Assign number, call from personal phone. Most realistic.
3. **AI Simulation** — Create personas: "impatient customer wanting to reschedule"
4. **Batch Testing** — Multiple scenarios automatically compared

## Testing Scenarios

| Scenario | What to Say | Expected |
|----------|-------------|----------|
| Happy path | "I'd like to book" | Collects info, books, confirms |
| FAQ | "What are your hours?" | Answers correctly |
| Hesitant | "I'm not sure yet" | Respects, stays helpful |
| Specific time | "Tuesday afternoon?" | Checks availability |
| Missing info | Refuse to give email | Asks politely again |
| Transfer | "Can I talk to someone?" | Transfers immediately |
| Frustrated | Repeat question 3x, sound annoyed | De-escalates, offers transfer |
| Off-topic | Ask about something unrelated | Redirects politely |
| Tool failure | (test by using invalid API key temporarily) | Graceful fallback |

## Iteration Process

1. Test → record what went wrong
2. Identify: prompt issue, tool issue, or voice issue?
3. Make ONE change at a time
4. Re-test same scenario
5. Verify fix didn't break other scenarios

## Common Problems & Fixes

| Symptom | Cause | Fix |
|---------|-------|-----|
| Talks too much | No brevity rule | Add "Keep responses to 1-2 sentences" |
| Doesn't offer booking | Trigger too passive | Add "Proactively offer to schedule if caller shows interest" |
| Books too early | No qualification gate | Add "Do NOT book until name AND email confirmed" |
| Sounds robotic | Voice temp too low | Increase `voice_temperature` to 0.7 |
| Goes off-topic | No boundaries | Add explicit "Don't" section |
| Ignores interruptions | Sensitivity too low | Increase `interruption_sensitivity` to 1.0-1.5 |
| Doesn't listen | Responsiveness too high | Decrease `responsiveness` to 0.8 |
| Wrong timezone | Config error | Verify timezone in tool config |
| Name mispronounced | Not boosted | Add to `boosted_keywords` |
| Calls dropping | Timeout reached | Increase `max_call_duration_ms` |
| n8n webhook fails | URL wrong or workflow inactive | Verify URL, ensure workflow active (not test mode) |
| Booking fails | Cal.com key expired | Regenerate, verify `cal_live_` prefix |
| Agent makes stuff up | Weak boundaries | Add "NEVER make up information" |
| KB not used | Not linked to agent | Verify KB assigned in agent settings |

## Retell Support

- Docs: docs.retellai.com
- Discord: discord.com/invite/DTzvrQfncB (active community + Retell team)
- Email: support@retellai.com
- Bot Builders Office Hours: Fridays 2pm Pacific on Discord
