# Retell LLM JSON Schema Reference

## Retell LLM Config (Single Prompt Agent)

```json
{
  "model": "gpt-4.1",
  "model_temperature": 0,
  "start_speaker": "agent",
  "begin_message": "First thing agent says when call connects.",
  "general_prompt": "Full system prompt for the agent.",
  "general_tools": [
    // Array of tool objects — see Tool Types below
  ]
}
```

## Retell LLM Config (Multi-State Agent)

```json
{
  "model": "gpt-4.1",
  "model_temperature": 0,
  "start_speaker": "agent",
  "begin_message": "First utterance.",
  "general_prompt": "Context shared across ALL states.",
  "general_tools": [
    // Tools available in ALL states
  ],
  "states": [
    {
      "name": "greeting",
      "state_prompt": "Prompt for this state only.",
      "edges": [
        {
          "destination_state_name": "qualification",
          "description": "When caller wants to book an appointment."
        }
      ],
      "tools": [
        // Tools available ONLY in this state
      ]
    },
    {
      "name": "qualification",
      "state_prompt": "Collect name, email, preferred time.",
      "edges": [
        {
          "destination_state_name": "booking",
          "description": "When all info collected."
        }
      ],
      "tools": []
    }
  ],
  "starting_state": "greeting"
}
```

## Available Models

Text LLMs: `gpt-4.1`, `gpt-4.1-mini`, `gpt-4.1-nano`, `gpt-5`, `gpt-5-mini`, `claude-4.5-sonnet`, `claude-4.5-haiku`, `gemini-2.5-flash`

Speech-to-speech (set `s2s_model` instead of `model`): `gpt-4o-realtime`, `gpt-realtime`

Default recommendation: `gpt-4.1` (best tool calling + cost balance)

## Tool Types

### End Call
```json
{
  "type": "end_call",
  "name": "end_call",
  "description": "End the call when the conversation is complete, the caller says goodbye, or there is nothing more to discuss."
}
```

### Transfer Call (Cold)
```json
{
  "type": "transfer_call",
  "name": "transfer_to_human",
  "description": "Transfer when: caller requests a human, caller is frustrated after 2 failed attempts, or question is outside your knowledge.",
  "transfer_destination": {
    "type": "predefined",
    "number": "+14155551234"
  },
  "transfer_option": {
    "type": "cold_transfer",
    "show_transferee_as_caller": false
  }
}
```

### Transfer Call (Warm — with whisper)
```json
{
  "type": "transfer_call",
  "name": "warm_transfer",
  "description": "Warm transfer to sales team when lead is qualified.",
  "transfer_destination": {
    "type": "predefined",
    "number": "+14155551234"
  },
  "transfer_option": {
    "type": "warm_transfer",
    "whisper_message": "Incoming call from {{caller_name}}. Interested in {{service_type}}."
  }
}
```

### Cal.com Booking (Native)
```json
{
  "type": "book_appointment_cal",
  "name": "book_appointment",
  "description": "Book an appointment ONLY after you have confirmed the caller's full name and email address. Offer available times and confirm before booking.",
  "cal_api_key": "cal_live_REPLACE_WITH_YOUR_KEY",
  "event_type_id": 12345,
  "timezone": "America/Los_Angeles"
}
```
Note: Replace `cal_api_key`, `event_type_id`, and `timezone` with actual values.

### Custom Function (Webhook — for n8n)
```json
{
  "type": "custom",
  "name": "process_request",
  "description": "Send caller information to backend for processing. Use after collecting required information.",
  "url": "https://REPLACE-WITH-YOUR-N8N-URL.app.n8n.cloud/webhook/retell-handler",
  "method": "POST",
  "parameters": {
    "type": "object",
    "properties": {
      "caller_name": {"type": "string", "description": "Caller's full name"},
      "caller_email": {"type": "string", "description": "Caller's email address"},
      "caller_phone": {"type": "string", "description": "Caller's phone number"},
      "action": {"type": "string", "description": "Action to take: book_appointment, capture_lead, check_availability"},
      "service_type": {"type": "string", "description": "Service the caller is interested in"},
      "preferred_date": {"type": "string", "description": "Caller's preferred date"},
      "preferred_time": {"type": "string", "description": "Caller's preferred time"},
      "notes": {"type": "string", "description": "Any additional details from the conversation"}
    },
    "required": ["caller_name", "action"]
  },
  "speak_during_execution": true,
  "speak_after_execution": true,
  "timeout_ms": 10000
}
```

### Check Availability (via Cal.com API)
```json
{
  "type": "custom",
  "name": "check_availability",
  "description": "Check available appointment slots for a given date. Use when caller asks about availability before booking.",
  "url": "https://REPLACE-WITH-YOUR-N8N-URL.app.n8n.cloud/webhook/check-availability",
  "method": "POST",
  "parameters": {
    "type": "object",
    "properties": {
      "date": {"type": "string", "description": "Date to check in YYYY-MM-DD format"},
      "service_type": {"type": "string", "description": "Type of appointment"}
    },
    "required": ["date"]
  },
  "speak_during_execution": true,
  "speak_after_execution": true
}
```

### Press Digit (IVR Navigation)
```json
{
  "type": "press_digit",
  "name": "press_digit",
  "description": "Press a digit on the keypad."
}
```

## Agent Settings (set in Agent, not LLM)

These go on the Agent object, not the LLM. Include in setup instructions:

| Setting | Recommended | Notes |
|---------|-------------|-------|
| `voice_id` | varies | See voice table in SKILL.md |
| `voice_speed` | 1.0 | |
| `voice_temperature` | 0.5 | 0=consistent, 2=expressive |
| `responsiveness` | 1.0 | How fast agent jumps in |
| `interruption_sensitivity` | 0.8 | How easily caller can interrupt |
| `enable_backchannel` | true | "uh-huh" while listening |
| `backchannel_frequency` | 0.8 | |
| `max_call_duration_ms` | 1800000 | 30 min safety cap |
| `end_call_after_silence_ms` | 30000 | End after 30s silence |
| `enable_voicemail_detection` | true | For outbound agents |
| `language` | "en-US" | |
| `data_storage_setting` | "everything" | Or "no_recording" for privacy |

## Voice Recommendations

| Voice ID | Gender | Style | Best For |
|----------|--------|-------|----------|
| `11labs-Adrian` | M | Professional, warm | B2B, services |
| `11labs-Rachel` | F | Friendly, warm | Customer service, healthcare |
| `11labs-Myra` | F | Professional, calm | Medical, legal, financial |
| `11labs-Chris` | M | Casual, friendly | Tech, startups |
| `openai-Alloy` | Neutral | Clear, balanced | High volume |
| `openai-Nova` | F | Energetic | Sales |
| `openai-Coral` | F | Warm | Receptionist |
| `openai-Sage` | Neutral | Thoughtful | Advisory |

Always set `fallback_voice_ids` from a different provider than primary.

## Dynamic Variables

Use `{{variable_name}}` in prompts and tool descriptions. Set defaults in `default_dynamic_variables`:
```json
{
  "default_dynamic_variables": {
    "business_name": "Bright Smile Dental",
    "agent_name": "Sarah",
    "transfer_number": "+14155551234"
  }
}
```

## Post-Call Analysis

Add to agent config (not LLM):
```json
{
  "post_call_analysis_data": [
    {"type": "string", "name": "caller_name", "description": "Full name"},
    {"type": "string", "name": "caller_intent", "description": "Reason for calling"},
    {"type": "boolean", "name": "appointment_booked", "description": "Whether booking succeeded"},
    {"type": "string", "name": "follow_up_needed", "description": "Required follow-up actions"}
  ]
}
```

## Timezone Codes

| Region | Code |
|--------|------|
| Pacific (LA, Vancouver) | `America/Los_Angeles` |
| Mountain (Denver, Calgary) | `America/Denver` |
| Central (Chicago, Dallas) | `America/Chicago` |
| Eastern (NY, Toronto) | `America/New_York` |
| UK | `Europe/London` |
| Central Europe | `Europe/Berlin` |
| Australia Eastern | `Australia/Sydney` |
