# Production Patterns

## Graceful Failure Handling

```
## If Booking Fails
"I apologize, I'm having a small hiccup with our calendar. Let me take down your preferred time and we'll confirm via text within the hour. What day and time work best?"

## If Webhook Times Out
"One moment... I apologize for the brief delay. I'll have our team reach out to you directly. What's the best number to reach you?"

## If Caller Info Wrong
"I want to make sure I have everything right. Could you spell your last name for me?"
```

## Confirmation Loops

```
## After Collecting Info
"Just to confirm: your name is [NAME], and your email is [EMAIL spelled out]. Is that correct?"

## After Booking
"You're all set for [DAY], [DATE] at [TIME]. You'll get a confirmation at [EMAIL]. Does that sound right?"
```

## Escape Hatches

```
Transfer when:
- Caller says "speak to a person" or similar
- Caller says "this isn't working"
- Frustrated (3+ interruptions)
- Question outside knowledge after 2 attempts
- Billing disputes or refunds

Script: "Absolutely, let me connect you with our team right now. One moment."
```

## Warm Transfer with Context

```json
{
  "transfer_option": {
    "type": "warm_transfer",
    "whisper_message": "Incoming call from {{caller_name}}. Interested in {{service_type}}. Qualified: {{status}}."
  }
}
```

## After-Hours Handling

```
[During hours] "Thanks for calling [Business]! How can I help?"
[After hours] "Thanks for calling [Business]. We're currently closed — open [HOURS]. I can still help schedule or answer questions."
```

## Voicemail Detection (Outbound)

```json
{
  "enable_voicemail_detection": true,
  "voicemail_message": "Hi, this is Sarah from [Business] calling about your upcoming appointment. Please call us back at [NUMBER]. Have a great day!",
  "voicemail_detection_timeout_ms": 30000
}
```

## Post-Call Analysis

```json
{
  "post_call_analysis_data": [
    {"type": "string", "name": "caller_name", "description": "Full name"},
    {"type": "string", "name": "caller_intent", "description": "Reason: booking, question, complaint, other"},
    {"type": "boolean", "name": "appointment_booked", "description": "Booking succeeded"},
    {"type": "string", "name": "follow_up_needed", "description": "Follow-up actions"},
    {"type": "number", "name": "satisfaction", "description": "Satisfaction 1-5"},
    {"type": "string", "name": "call_summary", "description": "2-3 sentence summary"}
  ]
}
```

## A/B Testing

Create two agent versions with different tones or approaches:
- Version A: Formal → "Good afternoon, thank you for calling..."
- Version B: Casual → "Hey there! Thanks for calling..."
Compare booking rates using Retell's analytics and versioning.

## Monitoring Targets

| Metric | Target |
|--------|--------|
| Booking rate | 30-60% |
| Avg call duration | 2-4 min |
| Transfer rate | Under 20% |
| Completion rate | Above 85% |
| Satisfaction | 4+ / 5 |
| Tool success rate | Above 95% |

## Knowledge Base Best Practices

- Upload website URL or sitemap for auto-scraping (auto-syncs every 24 hours)
- Upload PDFs/docs for policies, catalogs, procedures
- Manual text for custom Q&A pairs
- Keep prompts short — put detailed info in KB, not the prompt
- Test retrieval: ask questions and verify correct chunks return
- 10 free KBs included with every Retell account
