# Cal.com Setup & Integration

## Account Setup

1. Create account at cal.com (free: 1 event type; Pro $12/mo: multiple types)
2. Create Event Type: Dashboard → Event Types → New → set name, duration, location
3. Set Availability: working hours, buffer time (15 min), minimum notice (4 hrs)
4. Get Event Type ID: URL when editing → `cal.com/event-types/[THIS_NUMBER]`
5. Get API Key: Settings → Developer → API Keys → Create (starts with `cal_live_`)

## Retell Native Cal.com Tool

Simplest approach — Retell handles availability check and booking automatically.

```json
{
  "type": "book_appointment_cal",
  "name": "book_appointment",
  "description": "Book appointment when caller agrees AND you have their name and email.",
  "cal_api_key": "cal_live_xxxxxxxxxxxx",
  "event_type_id": 12345,
  "timezone": "America/Los_Angeles"
}
```

Retell auto-collects: name, email, time slot. Cal.com sends email confirmation.

### Limitations of Native
- One event type per tool (multiple tools needed for multiple types)
- No conditional routing
- No CRM sync
- No SMS confirmation (email only)
- For any of the above → use Cal.com + n8n

## Cal.com API v2 (for n8n integration)

### Check Availability
```
GET https://api.cal.com/v2/slots
Headers:
  Authorization: Bearer cal_live_xxxxx
  cal-api-version: 2024-09-04
Query:
  eventTypeSlug: your-event-slug
  start: 2025-02-10T00:00:00Z
  end: 2025-02-17T00:00:00Z
  timeZone: America/Los_Angeles
```

### Create Booking
```
POST https://api.cal.com/v2/bookings
Headers:
  Authorization: Bearer cal_live_xxxxx
  Content-Type: application/json
  cal-api-version: 2024-08-13
Body:
{
  "eventTypeId": 12345,
  "start": "2025-02-12T15:00:00Z",
  "attendee": {
    "name": "John Doe",
    "email": "john@example.com",
    "timeZone": "America/New_York"
  },
  "metadata": {"source": "voice-agent"}
}
```

**Critical**: `cal-api-version` header is REQUIRED. Use `2024-09-04` for slots, `2024-08-13` for bookings. Requests fail without it.

## Timezone Codes

| Region | Code |
|--------|------|
| Pacific (LA, Vancouver) | `America/Los_Angeles` |
| Mountain (Denver, Calgary) | `America/Denver` |
| Central (Chicago, Dallas) | `America/Chicago` |
| Eastern (NY, Toronto) | `America/New_York` |
| UK | `Europe/London` |
| Central Europe | `Europe/Berlin` |
| Australia Eastern | `Australia/Sydney` |

Set to **business timezone**. Cal.com converts for the caller.

## Troubleshooting

| Problem | Fix |
|---------|-----|
| 404 error | Missing `cal-api-version` header |
| 400 Bad Request | Attendee fields must be nested in `attendee` object, not top-level |
| Booking created but no email | Known Cal.com API v2 issue — verify in Cal.com dashboard, test with UI first |
| Wrong timezone | Verify timezone code matches business location |
| API key rejected | Must start with `cal_live_` (not test key) |
