---
name: retell-voice-agent
description: "Build production-ready Retell AI voice agents and output ready-to-use deliverable files. Use when creating AI receptionists, appointment schedulers, customer service agents, lead qualifiers, outbound callers, or any voice AI agent. Generates: (1) Retell LLM JSON config matching the Retell API schema that users paste into their dashboard, (2) n8n workflow JSON files if integrations are needed, (3) step-by-step setup instructions as a markdown file. Triggers: 'build retell agent', 'AI receptionist', 'voice agent', 'retell configuration', 'phone agent', 'booking agent', 'n8n webhook for retell', 'outbound calling agent', 'voice AI', 'appointment scheduling agent', 'build me a voice agent'."
---

# Retell Voice Agent Builder

Build voice agents and output ready-to-use files the user can deploy immediately.

## What This Skill Produces

Every build MUST output these files to `/mnt/user-data/outputs/`:

### Always Generated
1. **`retell-llm-config.json`** — Complete Retell LLM configuration matching the Create Retell LLM API schema. User copies the `general_prompt`, `general_tools`, `begin_message`, and `states` values into their Retell dashboard.
2. **`SETUP-INSTRUCTIONS.md`** — Numbered step-by-step guide to go from zero to live agent. Written for non-technical users.

### Generated When Needed
3. **`n8n-workflow.json`** — Complete n8n workflow JSON (importable via n8n Import button) when CRM, SMS, or custom webhook integrations are needed.
4. **`knowledge-base-content.md`** — Pre-formatted content for the Retell Knowledge Base when FAQ/business info is needed.

After generating all files, use `present_files` to share them and explain what each file is and what to do with it.

## Workflow

### Step 1: Discovery
Ask these questions (batch into 1-2 messages, don't interrogate):

**Must ask:**
1. What does the business do?
2. What should the agent handle? (book appointments, answer questions, qualify leads, take messages, transfer calls)
3. What happens after a call? (just answer questions, book via calendar, update CRM, send SMS, trigger workflow)
4. Business hours and timezone?
5. Transfer number for human escalation?

**Ask if relevant:**
- Booking: What scheduling tool? Event types? Duration?
- CRM: Which one? (HubSpot, Salesforce, Airtable, GoHighLevel)
- SMS: Send confirmations after booking?
- Lead qualification: What questions determine a good lead?
- Outbound: What's the goal of each call?
- Agent personality: Name, gender, tone?
- Website URL (for knowledge base)?

### Step 2: Determine Stack
```
Answer questions only → Stack A (Retell only)
Book appointments (simple) → Stack B (Retell + Cal.com native tool)
Qualify leads / capture to CRM → Stack C (Retell + n8n webhook)
Booking + CRM + SMS → Stack D (Retell + Cal.com via n8n + CRM + SMS)
```

### Step 3: Generate Files

Read [references/retell-llm-schema.md](references/retell-llm-schema.md) for the exact JSON structure and all tool type schemas before generating any JSON.

Read [references/industry-templates.md](references/industry-templates.md) if the business matches a known industry for prompt inspiration.

If n8n is needed, read [references/n8n-workflows.md](references/n8n-workflows.md) for workflow JSON patterns.

#### File 1: retell-llm-config.json

Generate valid JSON matching Retell's Create Retell LLM API schema:

```json
{
  "model": "gpt-4.1",
  "model_temperature": 0,
  "start_speaker": "agent",
  "begin_message": "Thanks for calling [Business]! This is [Name], how can I help?",
  "general_prompt": "[Full agent prompt here]",
  "general_tools": [
    {"type": "end_call", "name": "end_call", "description": "..."},
    ...additional tools
  ]
}
```

For multi-state agents, use `states`, `starting_state`, and `edges` instead of a single prompt. See schema reference for structure.

**Prompt rules:**
- "Keep responses to 1-2 sentences" in EVERY prompt
- Specific tool trigger conditions: "Use book_appointment ONLY after name AND email confirmed"
- Include 2-3 example conversation exchanges
- Explicit boundaries: "You must NEVER quote pricing"
- Error handling: what to say when tools fail
- Recording disclosure in greeting for two-party consent regions
- Confirmation loops: repeat back collected info before acting

**Tool description rules:**
- Description tells the LLM WHEN to use it — be very specific
- Always include `end_call` tool
- Always include `transfer_call` if there's a human fallback number
- Cal.com tool needs: `cal_api_key`, `event_type_id`, `timezone`
- Custom webhook tool needs: `url`, `method`, `parameters` with JSON schema
- Set `speak_during_execution: true` and `speak_after_execution: true` on webhook tools

#### File 2: SETUP-INSTRUCTIONS.md

Write for a non-technical person. Use this structure:

```markdown
# [Business Name] Voice Agent — Setup Guide

## What You're Setting Up
[1-2 sentences: what this agent does]

## What's Been Created For You
- **retell-llm-config.json** — Your agent's brain (prompt + tools)
- **n8n-workflow.json** — [if applicable] Your automation workflow
- **knowledge-base-content.md** — [if applicable] FAQ content for the agent

## Prerequisites
- [ ] Retell AI account (retellai.com) — $10 free credit
- [ ] [Cal.com account if applicable]
- [ ] [n8n account if applicable]
- [ ] Credit card for phone number (~$2/month)

## Step-by-Step Setup

### Step 1: Create the Agent Brain (Retell LLM)
1. Log in to dashboard.retellai.com
2. Click "LLMs" in the left sidebar
3. Click "+ Create"
4. Open `retell-llm-config.json` in a text editor
5. Copy the `begin_message` value → paste into "Begin Message"
6. Copy the `general_prompt` value → paste into "General Prompt"
7. For each tool in `general_tools`, click "+ Add Tool" and configure:
   [list each specific tool with exact field mappings]
8. Set Model to "GPT-4.1"
9. Click "Save"

### Step 2: Create the Voice Agent
1. Click "Agents" in the left sidebar
2. Click "+ Create Agent"
3. Select "Single Prompt Agent" [or Conversation Flow if applicable]
4. Select the LLM you just created
5. Choose voice: [specific recommendation]
6. Configure settings:
   - Voice Speed: 1.0
   - Responsiveness: 1.0
   - Interruption Sensitivity: 0.8
   - Enable Backchannel: Yes
7. Click "Save"

### Step 3: Get a Phone Number
1. Click "Phone Numbers" in the left sidebar
2. Click "+ Buy Number"
3. Select area code [suggest based on business location]
4. Assign to your agent (Inbound Agent dropdown)
5. Done! Call the number to test.

### [Optional] Step 4: Set Up Knowledge Base
[Only if knowledge-base-content.md was generated]
1. Click "Knowledge Base" in left sidebar
2. Click "+ Create"
3. Choose "Manual Text"
4. Paste contents of `knowledge-base-content.md`
5. Click "Save"
6. Go back to your LLM → add this Knowledge Base ID

### [Optional] Step 5: Set Up n8n Workflow
[Only if n8n-workflow.json was generated]
1. Log in to n8n (app.n8n.cloud)
2. Click "..." menu → "Import from File"
3. Select `n8n-workflow.json`
4. Open the Webhook node → copy the Production URL
5. Go to Retell dashboard → your LLM → the webhook tool
6. Replace the placeholder URL with your n8n webhook URL
7. Configure credentials in n8n:
   [list each integration node and what credentials are needed]
8. Activate the workflow (toggle in top right)

### [Optional] Step 6: Set Up Cal.com
[Only if Cal.com booking is used]
1. Log in to cal.com
2. Create Event Type: [specific name and duration]
3. Settings → Developer → Create API Key (starts with cal_live_)
4. Copy Event Type ID from the URL: cal.com/event-types/[THIS_NUMBER]
5. In Retell: update the booking tool with your API key and Event Type ID

## Testing Checklist
Call your number and test each scenario:
- [ ] "I'd like to book an appointment" → books correctly
- [ ] "What are your hours?" → answers correctly
- [ ] "Can I speak to someone?" → transfers
- [ ] Hang up → call ends cleanly
- [ ] [Additional scenario-specific tests]

## Troubleshooting
[Include 5-8 most likely issues with fixes — see references/testing-and-troubleshooting.md]

## Monthly Costs
[Itemized cost estimate based on their stack]
```

#### File 3: n8n-workflow.json (if needed)

Generate importable n8n workflow JSON. Read [references/n8n-workflows.md](references/n8n-workflows.md) for patterns.

Key rules:
- Webhook node must use `"responseMode": "responseNode"`
- Always end with Respond to Webhook node returning `{"result": "spoken text"}`
- Include an error handler that returns a graceful message
- Use placeholder credentials — instructions tell user where to add real ones

#### File 4: knowledge-base-content.md (if needed)

Format as clean Q&A or structured info the user pastes into Retell's Knowledge Base:
```markdown
# [Business Name] — Agent Knowledge Base

## Business Info
- Hours: ...
- Location: ...
- Phone: ...

## Services
[Structured list]

## FAQ
Q: ...
A: ...

## Policies
[Cancellation, insurance, pricing, etc.]
```

### Step 4: Present Files and Explain

After creating all files, present them and give a clear summary:

```
Here's everything you need to deploy your voice agent:

📄 **retell-llm-config.json** — Your agent configuration. Follow the setup guide to paste this into Retell.
📄 **SETUP-INSTRUCTIONS.md** — Step-by-step guide from zero to live agent.
📄 **n8n-workflow.json** — [if created] Import this into n8n for [what it does].
📄 **knowledge-base-content.md** — [if created] Paste this into Retell Knowledge Base.

Start with SETUP-INSTRUCTIONS.md — it walks you through everything in order.
```

## Reference Files

- [references/retell-llm-schema.md](references/retell-llm-schema.md) — Exact Retell LLM JSON schema, all tool types, agent settings
- [references/industry-templates.md](references/industry-templates.md) — Dental, HVAC, real estate, consulting, storage, medical prompt templates
- [references/n8n-workflows.md](references/n8n-workflows.md) — Importable n8n workflow patterns
- [references/cal-com-setup.md](references/cal-com-setup.md) — Cal.com API v2 endpoints, timezone codes
- [references/testing-and-troubleshooting.md](references/testing-and-troubleshooting.md) — Common problems and fixes
- [references/production-patterns.md](references/production-patterns.md) — Failure handling, confirmation loops, warm transfers
